/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapping;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.ai.msg.Telegram;
import com.badlogic.gdx.ai.msg.Telegraph;
import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.IntMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import technology.rocketjump.undermount.assets.model.FloorType;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.assets.model.WallType;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.gamecontext.GameContextAware;
import technology.rocketjump.undermount.mapping.OutdoorLightProcessor;
import technology.rocketjump.undermount.mapping.tile.CompassDirection;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.mapping.tile.MapVertex;
import technology.rocketjump.undermount.mapping.tile.TileNeighbours;
import technology.rocketjump.undermount.mapping.tile.TileRoof;
import technology.rocketjump.undermount.mapping.tile.designation.TileDesignation;
import technology.rocketjump.undermount.mapping.tile.layout.WallLayout;
import technology.rocketjump.undermount.mapping.tile.wall.Wall;
import technology.rocketjump.undermount.messaging.types.ApplyDesignationMessage;
import technology.rocketjump.undermount.messaging.types.AreaSelectionMessage;
import technology.rocketjump.undermount.messaging.types.EntityPositionChangedMessage;
import technology.rocketjump.undermount.messaging.types.RemoveDesignationMessage;
import technology.rocketjump.undermount.messaging.types.RoomPlacementMessage;
import technology.rocketjump.undermount.rooms.Room;
import technology.rocketjump.undermount.rooms.RoomTile;
import technology.rocketjump.undermount.ui.GameInteractionMode;
import technology.rocketjump.undermount.ui.GameInteractionStateContainer;

@Singleton
public class MapMessageHandler
implements Telegraph,
GameContextAware {
    private final MessageDispatcher messageDispatcher;
    private final OutdoorLightProcessor outdoorLightProcessor;
    private final GameInteractionStateContainer interactionStateContainer;
    private GameContext gameContext;

    @Inject
    public MapMessageHandler(MessageDispatcher messageDispatcher, OutdoorLightProcessor outdoorLightProcessor, GameInteractionStateContainer interactionStateContainer) {
        this.messageDispatcher = messageDispatcher;
        this.outdoorLightProcessor = outdoorLightProcessor;
        this.interactionStateContainer = interactionStateContainer;
        messageDispatcher.addListener(this, 310);
        messageDispatcher.addListener(this, 250);
        messageDispatcher.addListener(this, 249);
        messageDispatcher.addListener(this, 501);
        messageDispatcher.addListener(this, 606);
    }

    @Override
    public boolean handleMessage(Telegram msg) {
        switch (msg.message) {
            case 250: {
                return this.handle((AreaSelectionMessage)msg.extraInfo);
            }
            case 249: {
                return this.handle((RoomPlacementMessage)msg.extraInfo);
            }
            case 310: {
                return this.handle((EntityPositionChangedMessage)msg.extraInfo);
            }
            case 606: {
                GridPoint2 location = (GridPoint2)msg.extraInfo;
                return this.handleRemoveWall(location);
            }
            case 501: {
                this.gameContext.getAreaMap().getEnvironment().setCurrentSeason(this.gameContext.getAreaMap().getEnvironment().getCurrentSeason().getNext());
                return true;
            }
        }
        throw new IllegalArgumentException("Unexpected message type " + msg.message + " received by " + this.toString() + ", " + msg.toString());
    }

    private boolean handle(RoomPlacementMessage roomPlacementMessage) {
        Map<GridPoint2, RoomTile> roomTilesToPlace = roomPlacementMessage.getRoomTiles();
        LinkedList<Room> newRooms = new LinkedList<Room>();
        while (!roomTilesToPlace.isEmpty()) {
            RoomTile firstRoomTile = roomTilesToPlace.values().iterator().next();
            roomTilesToPlace.remove(firstRoomTile.getTilePosition());
            Room newRoom = new Room(roomPlacementMessage.getRoomType());
            this.addTilesToRoom(firstRoomTile, roomTilesToPlace, newRoom);
            newRoom.updateLayout(this.gameContext.getAreaMap());
            this.gameContext.getAreaMap().getRooms().put(newRoom.getRoomId(), newRoom);
            newRooms.add(newRoom);
        }
        for (Room newRoom : newRooms) {
            long thisRoomId = newRoom.getRoomId();
            HashSet<Long> roomsToMergeFrom = new HashSet<Long>();
            for (Map.Entry<GridPoint2, RoomTile> entry : newRoom.entrySet()) {
                if (!entry.getValue().isAtRoomEdge()) continue;
                for (MapTile neighbourTile : this.gameContext.getAreaMap().getOrthogonalNeighbours(entry.getKey().x, entry.getKey().y).values()) {
                    Room neighbourRoom;
                    if (!neighbourTile.hasRoom() || (neighbourRoom = neighbourTile.getRoomTile().getRoom()).getRoomId() == thisRoomId || !neighbourRoom.getRoomType().equals(newRoom.getRoomType())) continue;
                    roomsToMergeFrom.add(neighbourRoom.getRoomId());
                }
            }
            if (roomsToMergeFrom.isEmpty()) continue;
            while (!roomsToMergeFrom.isEmpty()) {
                long roomId = (Long)roomsToMergeFrom.iterator().next();
                roomsToMergeFrom.remove(roomId);
                Room roomToMergeFrom = this.gameContext.getAreaMap().getRoom(roomId);
                roomToMergeFrom.mergeInto(newRoom);
                this.gameContext.getAreaMap().removeRoom(roomId);
            }
            newRoom.updateLayout(this.gameContext.getAreaMap());
        }
        return true;
    }

    private void addTilesToRoom(RoomTile currentRoomTile, Map<GridPoint2, RoomTile> remainingRoomTiles, Room newRoom) {
        currentRoomTile.setRoom(newRoom);
        MapTile mapTile = this.gameContext.getAreaMap().getTile(currentRoomTile.getTilePosition());
        newRoom.addTile(currentRoomTile);
        mapTile.setRoomTile(currentRoomTile);
        TileNeighbours orthogonalNeighbours = this.gameContext.getAreaMap().getOrthogonalNeighbours(mapTile.getTileX(), mapTile.getTileY());
        for (MapTile neighbourTile : orthogonalNeighbours.values()) {
            if (!remainingRoomTiles.containsKey(neighbourTile.getTilePosition())) continue;
            RoomTile neighbourRoomTile = remainingRoomTiles.remove(neighbourTile.getTilePosition());
            this.addTilesToRoom(neighbourRoomTile, remainingRoomTiles, newRoom);
        }
    }

    private boolean handle(AreaSelectionMessage areaSelectionMessage) {
        GridPoint2 minTile = new GridPoint2(MathUtils.floor(areaSelectionMessage.getMinPoint().x), MathUtils.floor(areaSelectionMessage.getMinPoint().y));
        GridPoint2 maxTile = new GridPoint2(MathUtils.floor(areaSelectionMessage.getMaxPoint().x), MathUtils.floor(areaSelectionMessage.getMaxPoint().y));
        HashSet<GridPoint2> roomTilesToRemove = new HashSet<GridPoint2>();
        for (int x = minTile.x; x <= maxTile.x; ++x) {
            for (int y = minTile.y; y <= maxTile.y; ++y) {
                MapTile tile = this.gameContext.getAreaMap().getTile(x, y);
                if (tile == null) continue;
                if (this.interactionStateContainer.getInteractionMode().equals((Object)GameInteractionMode.REMOVE_DESIGNATIONS)) {
                    if (tile.getDesignation() != null) {
                        this.messageDispatcher.dispatchMessage(255, new RemoveDesignationMessage(tile, tile.getDesignation()));
                    }
                    tile.setDesignation(null);
                    continue;
                }
                if (this.interactionStateContainer.getInteractionMode().designationCheck == null || !this.interactionStateContainer.getInteractionMode().designationCheck.shouldDesignationApply(tile)) continue;
                if (this.interactionStateContainer.getInteractionMode().equals((Object)GameInteractionMode.REMOVE_ROOMS)) {
                    roomTilesToRemove.add(tile.getTilePosition());
                    continue;
                }
                TileDesignation designationToApply = this.interactionStateContainer.getInteractionMode().getDesignationToApply();
                tile.setDesignation(designationToApply);
                this.messageDispatcher.dispatchMessage(254, new ApplyDesignationMessage(tile, designationToApply));
            }
        }
        if (!roomTilesToRemove.isEmpty()) {
            this.removeRoomTiles(roomTilesToRemove);
        }
        return true;
    }

    private void removeRoomTiles(Set<GridPoint2> roomTilesToRemove) {
        HashSet<Long> roomsWithRemovedTiles = new HashSet<Long>();
        for (GridPoint2 tileLocation : roomTilesToRemove) {
            MapTile tile = this.gameContext.getAreaMap().getTile(tileLocation);
            RoomTile roomTile = tile.getRoomTile();
            roomsWithRemovedTiles.add(roomTile.getRoom().getRoomId());
            roomTile.getRoom().removeTile(tileLocation);
            tile.setRoomTile(null);
        }
        for (Long roomId : roomsWithRemovedTiles) {
            Room modifiedRoom = this.gameContext.getAreaMap().getRoom(roomId);
            if (modifiedRoom.isEmpty()) {
                this.gameContext.getAreaMap().removeRoom(roomId);
                continue;
            }
            this.splitRoomIfNecessary(modifiedRoom);
        }
    }

    private void splitRoomIfNecessary(Room modifiedRoom) {
        HashSet<GridPoint2> traversed = new HashSet<GridPoint2>();
        IntMap<HashSet<GridPoint2>> tileGroups = new IntMap<HashSet<GridPoint2>>();
        int cursor = 1;
        Set<GridPoint2> allRoomTiles = modifiedRoom.keySet();
        for (GridPoint2 roomTile : allRoomTiles) {
            if (traversed.contains(roomTile)) continue;
            HashSet<GridPoint2> roomTileGroup = new HashSet<GridPoint2>();
            tileGroups.put(cursor, roomTileGroup);
            ++cursor;
            this.addAdjacentTilesToGroup(roomTile, traversed, roomTileGroup, modifiedRoom);
        }
        if (tileGroups.size > 1) {
            for (int groupCursor = 1; groupCursor < tileGroups.size; ++groupCursor) {
                Set newRoomGroup = (Set)tileGroups.get(groupCursor);
                Room newRoom = new Room(modifiedRoom.getRoomType());
                for (GridPoint2 positionToMove : newRoomGroup) {
                    RoomTile roomTileToMove = modifiedRoom.removeTile(positionToMove);
                    roomTileToMove.setRoom(newRoom);
                    newRoom.addTile(roomTileToMove);
                }
                this.gameContext.getAreaMap().getRooms().put(newRoom.getRoomId(), newRoom);
                newRoom.updateLayout(this.gameContext.getAreaMap());
            }
        }
        modifiedRoom.updateLayout(this.gameContext.getAreaMap());
    }

    private void addAdjacentTilesToGroup(GridPoint2 currentTile, Set<GridPoint2> traversed, Set<GridPoint2> roomTileGroup, Room currentRoom) {
        roomTileGroup.add(currentTile);
        traversed.add(currentTile);
        for (MapTile neighbourTile : this.gameContext.getAreaMap().getOrthogonalNeighbours(currentTile.x, currentTile.y).values()) {
            if (traversed.contains(neighbourTile.getTilePosition()) || !neighbourTile.hasRoom() || neighbourTile.getRoomTile().getRoom().getRoomId() != currentRoom.getRoomId()) continue;
            this.addAdjacentTilesToGroup(neighbourTile.getTilePosition(), traversed, roomTileGroup, currentRoom);
        }
    }

    private boolean handle(EntityPositionChangedMessage message) {
        MapTile oldCell = this.gameContext.getAreaMap().getTile(message.getOldPosition());
        if (oldCell != null) {
            Entity entity = oldCell.removeEntity(message.getEntityId());
            if (entity == null) {
                return false;
            }
            for (GridPoint2 otherTilePosition : entity.calculateOtherTilePositions()) {
                MapTile otherTile = this.gameContext.getAreaMap().getTile(otherTilePosition);
                if (otherTile == null) continue;
                otherTile.removeEntity(message.getEntityId());
            }
            MapTile newCell = this.gameContext.getAreaMap().getTile(message.getNewPosition());
            if (newCell != null) {
                newCell.addEntity(entity);
                for (GridPoint2 otherTilePosition : entity.calculateOtherTilePositions()) {
                    MapTile otherTile = this.gameContext.getAreaMap().getTile(otherTilePosition);
                    if (otherTile == null) continue;
                    otherTile.addEntity(entity);
                }
            } else if (oldCell != null) {
                oldCell.addEntity(entity);
                for (GridPoint2 otherTilePosition : entity.calculateOtherTilePositions()) {
                    MapTile otherTile = this.gameContext.getAreaMap().getTile(otherTilePosition);
                    if (otherTile == null) continue;
                    otherTile.addEntity(entity);
                }
            } else {
                System.out.println("Lost entity with ID " + message.getEntityId() + " from " + message.getOldPosition());
            }
        }
        return true;
    }

    public void addWall(GridPoint2 location, GameMaterial wallMaterial, WallType wallType) {
        MapTile cell = this.gameContext.getAreaMap().getTile(location);
        TileNeighbours tileNeighbours = this.gameContext.getAreaMap().getNeighbours(location);
        WallLayout wallLayout = new WallLayout(tileNeighbours);
        TileRoof newRoof = TileRoof.CONSTRUCTED;
        if (cell.getRoof().equals((Object)TileRoof.UNDERGROUND)) {
            newRoof = TileRoof.UNDERGROUND;
        }
        cell.setWall(new Wall(wallLayout, wallType, wallMaterial), newRoof);
        MapMessageHandler.updateCell(cell, this.gameContext);
        this.messageDispatcher.dispatchMessage(605, location);
        if (cell.getRoof().equals((Object)TileRoof.UNDERGROUND)) {
            EnumMap<CompassDirection, MapVertex> cellVertices = this.gameContext.getAreaMap().getVertexNeighboursOfCell(cell);
            for (MapVertex cellVertex : cellVertices.values()) {
                TileNeighbours neighboursOfCellVertex = this.gameContext.getAreaMap().getTileNeighboursOfVertex(cellVertex);
                boolean vertexSurroundedByIndoorCells = true;
                for (MapTile vertexNeighbour : neighboursOfCellVertex.values()) {
                    if (vertexNeighbour == null || !vertexNeighbour.getRoof().equals((Object)TileRoof.OPEN)) continue;
                    vertexSurroundedByIndoorCells = false;
                    break;
                }
                if (!vertexSurroundedByIndoorCells) continue;
                this.outdoorLightProcessor.propagateDarknessFromVertex(this.gameContext.getAreaMap(), cellVertex);
            }
        }
    }

    private boolean handleRemoveWall(GridPoint2 location) {
        MapTile tile = this.gameContext.getAreaMap().getTile(location);
        if (tile != null && tile.hasWall()) {
            GameMaterial floorMaterial = tile.getWall().getMaterial();
            tile.setWall(null, tile.getRoof());
            tile.getFloor().setMaterial(floorMaterial);
            for (MapVertex vertex : this.gameContext.getAreaMap().getVertexNeighboursOfCell(tile).values()) {
                this.outdoorLightProcessor.propagateLightFromMapVertex(this.gameContext.getAreaMap(), vertex, vertex.getOutsideLightAmount());
            }
            MapMessageHandler.updateCell(tile, this.gameContext);
            this.messageDispatcher.dispatchMessage(607, location);
            for (MapTile neighbourTile : this.gameContext.getAreaMap().getOrthogonalNeighbours(location.x, location.y).values()) {
                if (!neighbourTile.hasDoorway()) continue;
                this.messageDispatcher.dispatchMessage(809, neighbourTile.getTilePosition());
            }
        }
        return true;
    }

    public static void updateCell(MapTile cell, GameContext gameContext) {
        TileNeighbours neighbours = gameContext.getAreaMap().getNeighbours(cell.getTileX(), cell.getTileY());
        cell.update(neighbours, gameContext.getAreaMap().getVertices(cell.getTileX(), cell.getTileY()));
        for (MapTile cellNeighbour : neighbours.values()) {
            cellNeighbour.update(gameContext.getAreaMap().getNeighbours(cellNeighbour.getTileX(), cellNeighbour.getTileY()), gameContext.getAreaMap().getVertices(cell.getTileX(), cell.getTileY()));
        }
    }

    public void changeFloor(int tileX, int tileY, FloorType floorType, GameMaterial material) {
        MapTile cell = this.gameContext.getAreaMap().getTile(tileX, tileY);
        TileNeighbours tileNeighbours = this.gameContext.getAreaMap().getNeighbours(tileX, tileY);
        cell.getFloor().setFloorType(floorType);
        cell.getFloor().setMaterial(material);
        for (MapTile neighbourCell : tileNeighbours.values()) {
            neighbourCell.update(this.gameContext.getAreaMap().getNeighbours(neighbourCell.getTileX(), neighbourCell.getTileY()), this.gameContext.getAreaMap().getVertices(cell.getTileX(), cell.getTileY()));
        }
    }

    public void markAsOutside(int tileX, int tileY) {
        MapTile cell = this.gameContext.getAreaMap().getTile(tileX, tileY);
        cell.setRoof(TileRoof.OPEN);
        for (MapVertex vertex : this.gameContext.getAreaMap().getVertexNeighboursOfCell(cell).values()) {
            vertex.setOutsideLightAmount(1.0f);
            this.outdoorLightProcessor.propagateLightFromMapVertex(this.gameContext.getAreaMap(), vertex, 1.0f);
        }
    }

    @Override
    public void onContextChange(GameContext gameContext) {
        this.gameContext = gameContext;
    }
}

